//
//  OPDatabaseObject.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-02-20.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>
#import <OnePasswordDataModel/OPGenericProfile.h>

typedef enum {
	OPObjectTypeItem = 1,
	OPObjectTypeFolder = 2,
	OPObjectTypeAttachment = 3,
	OPObjectTypeProfile = 100
} OPObjectType;


#define kObjectFlags @"objectFlags"
#define kLoadedDetails @"kLoadedDetails"
#define kLoadedAttachments @"kLoadedAttachments"

@protocol OPDisplayOrderable <NSObject>
@property (nonatomic) NSUInteger displayOrder;
@end

@protocol OPSyncable <NSObject>

@property (nonatomic, readwrite) BOOL authentic;
@property (nonatomic, readonly) BOOL dirtyRow;
@property (nonatomic) BOOL trashed;

@property (nonatomic, readonly) OPObjectType objectType;
@property (nonatomic, readonly) OPID oid;
@property (strong, nonatomic) NSString * uuid;
@property (nonatomic) OPTimestamp updatedAt;
@property (nonatomic) OPTimestamp txTimestamp;
@property (nonatomic, readonly) BOOL isTombstone;
@property (nonatomic, readonly) BOOL isFolder;

- (id<OPSyncable>)mergeWithConflict:(id<OPSyncable>)conflictObject;
- (id<OPSyncable>)objectByReplacingWith:(id<OPSyncable>)object;

- (void)markRowDirty;

- (void)willSave;
- (void)didSave;

- (void)copyOidFrom:(id<OPSyncable>)other;

@end

@class OPProfile;

typedef union {
	int32_t intValue;
	
	struct {
		unsigned int dirtyRow:1;
		unsigned int dirtyDisplayOrder:1;
		
		unsigned int loadingDetails:1;
		unsigned int detailsLoaded:1;

		unsigned int loadingAttachments:1;
		unsigned int attachmentsLoaded:1;
		
		unsigned int trashed:1;
		unsigned int authentic:1;
	};
} OPObjectFlags;


@interface OPDatabaseObject : NSObject <NSSecureCoding> {
    OPObjectFlags _objectFlags;
}

@property (nonatomic, readonly) BOOL dirtyRow;
@property (nonatomic, readonly) BOOL dirtyDisplayOrder;

@property (nonatomic, readonly) BOOL loaded;

@property (nonatomic, readonly) BOOL loadingDetails;
@property (nonatomic, readonly) BOOL detailsLoaded;

@property (nonatomic, readonly) BOOL loadingAttachments;
@property (nonatomic, readonly) BOOL attachmentsLoaded;

@property (nonatomic, readwrite) BOOL authentic;
@property (nonatomic) BOOL trashed;

@property (nonatomic, readonly) OPID oid;
@property (nonatomic, readonly) BOOL hasOid;
@property (nonatomic, readonly) OPID profileId;

@property (nonatomic, strong) id<OPGenericProfile> profile;
@property (nonatomic, readonly, assign) OPProfileType profileType;

- (id)initNew;
- (id)initExistingWithID:(OPID)oid;

- (void)willSerialize;
- (void)willSave;
- (void)didSave;
- (void)didLoad;

- (void)_setOid:(OPID)oid;
- (void)markRowDirty;
- (void)markDisplayOrderDirty;

- (void)markLoadingDetails;
- (void)markDetailsLoaded;

- (void)markLoadingAttachments;
- (void)markAttachmentsLoaded;

- (NSDictionary *)allAttributes;
- (void)setAllAttributes:(NSDictionary *)allAttributes;

- (void)saveAllAttributes:(NSMutableDictionary *)dict;
- (void)restoreAllAttributes:(NSDictionary *)dict;

- (BOOL)validateAndRepairImportedProperties;

@end
